/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_10;

import lotus.domino.*;

/**
 * @author Thomas Ekert
 *
 */
public abstract class DJLoopCommand {

	public static final int TYPE_UNDEFINED = -1;
	public static final int TYPE_DATABASE = 1;
	public static final int TYPE_VIEW = 2;
	public static final int TYPE_COLLECTION = 3;
	private Database db=null;
	private View view=null;
	private DocumentCollection dc=null;
	private int type = TYPE_UNDEFINED;
	
	/**
	 * @param loopBase - Objekt (Database, View oder DocumentCollection) auf
	 * dem das Command spter im Loop ausgefhrt wird.
	 * @see DJLoopExecutor(DJLoopCommand)
	 * @throws NotesException
	 */
	protected DJLoopCommand (Base loopBase) {
		if (loopBase instanceof DocumentCollection) {
			dc = (DocumentCollection) loopBase;
			type=TYPE_COLLECTION;
		} else if (loopBase instanceof View) {
			view = (View) loopBase;
			type=TYPE_VIEW;
		} else if (loopBase instanceof Database) {
			db=(Database) loopBase;
			type=TYPE_DATABASE;
		} else {
			type=TYPE_UNDEFINED;
			throw new ClassCastException("Cannot convert " + loopBase.getClass().getName() + " lotus.domino.View, lotus.domino.Database or lotus.domino.DocumentCollection");
		}
	}
	
	/**
	 * @param doc - Dokument, auf dem die Verarbeitung durchgefhrt wird.
	 * @return - soll false zurckgeben, falls die Verarbeitung abgebrochen werden soll
	 * @throws NotesException
	 */
	public abstract boolean execute (Document doc) throws NotesException;
	
	public DocumentCollection getCollection () {
		return dc;
	}
	
	public View getView () {
		return view;
	}

	public Database getDatabase () {
		return db;
	}
	
	public int getType() {
		return type;
	}

}
